/**
 * WordPress dependencies
 */
import '@wordpress/notices';
import { __ } from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import '@ithemes/security.packages.data';
import '@ithemes/security.user-groups.api';
import { Page } from '@ithemes/security.pages.settings';
import { Layout } from './components';
import { useCompletionSteps, useSearchProviders } from './utils';
import './hooks';

export default function App() {
	useCompletionSteps();
	useSearchProviders();

	return (
		<Page
			id="user-groups"
			title={ __( 'User Groups', 'it-l10n-ithemes-security-pro' ) }
			icon="groups"
			priority={ 10 }
			roots={ [ 'settings', 'import' ] }
		>
			{ () => <Layout /> }
		</Page>
	);
}
