module.exports = {
  name: 'otgs-icons',
  inputDir: './icons/dest', // (required)
  outputDir: './css/', // (required)
  fontTypes: ['eot', 'ttf', 'woff', 'woff2'],
  assetTypes: ['scss', 'css', 'html'],
  prefix: 'otgs-ico',
  fontsUrl: '../fonts',
  normalize: true,
  formatOptions: {
    // Pass options directly to `svgicons2svgfont`
    woff: {
      // Woff Extended Metadata Block - see https://www.w3.org/TR/WOFF/#Metadata
      metadata: '...'
    },
    json: {
      // render the JSON human readable with two spaces indentation (default is none, so minified)
      indent: 2
    },
    ts: {
      // select what kind of types you want to generate (default `['enum', 'constant', 'literalId', 'literalKey']`)
      types: ['constant', 'literalId'],
      // render the types with `'` instead of `"` (default is `"`)
      singleQuotes: true
    }
  },
  templates: {
    html: './templates/html.hbs',
    scss: './templates/scss.hbs',
    css: './templates/css.hbs'
  },
  pathOptions: {
    eot: './fonts/otgs-icons.eot',
    ttf: './fonts/otgs-icons.ttf',
    woff: './fonts/otgs-icons.woff',
    woff2: './fonts/otgs-icons.woff2',
    css: './css/otgs-icons.css',
    scss: './css/otgs-icons.scss',
    html: './icons-overview.html'
  },
  // set old codes from previous icon set so we don't need to handle old markup
  codepoints: {
    // old codes
    'note-add': 97, // decimal representation of 0xe000
    'note-add-o': 98,
    'translated': 99,
    'yes': 100,
    'in-progress': 101,
    'copy': 102,
    'copy-o': 103,
    'note-edit': 105,
    'add': 107,
    'refresh': 108,
    'no': 110,
    'not-translated': 111,
    'delete': 112,
    'waiting': 113,
    'warning': 115,
    'original': 116,
    'needs-update': 117,
    'cred': 119,
    'layouts': 120,
    'module-manager': 121,
    'toolset': 122,
    'types': 65,
    'views': 66,
    'edit': 104,
    'duplicate': 109,
    'basket': 114,
    'discoverwp': 67,
    'otgs': 69,
    'wrench': 70,
    'link': 71,
    'envelope-o': 72,
    'user': 73,
    'wpml-cms-nav': 74,
    'wpml-media': 75,
    'wpml-string-translation': 76,
    'wpml-translation-management': 77,
    'picture': 78,
    'toolset-training': 79,
    'access-title': 80,
    'views-title': 81,
    'cred-title': 82,
    'layouts-title': 83,
    'types-title': 84,
    'module-manager-title': 85,
    'access': 118,
    'bullhorn': 86,
    'comment': 87,
    'quote': 88,
    'star': 90,
    'wpml': 68,
    'edit-note-o': 106,
    'spinner': 48,
    'thumbsup': 89,
    'status': 49,
    'file': 50,
    'cancel': 51,
    'download': 52,
    'close': 61784,
    'help': 61987,
    'info': 62280,
    'caret-up': 61762,
    'caret-right': 61753,
    'caret-down': 61760,
    'caret-left': 61761,
    'unlink': 61989,
    'translation': 62246,
    'new': 62772,
    'mail': 62566,
    'chat': 61733,
    'sent': 62224,
    'lock': 61792,
    'unlock': 62760,
    'media': 62003,
    'wpml-sticky-links': 61699,

    // new codes
    'add-circle-o': 63001,
    'add-circle': 63002,
    'align-justify': 63003,
    'archive': 63004,
    'arrow-down': 63005,
    'arrow-left': 63006,
    'arrow-right': 63007,
    'arrow-up': 63008,
    'bell-o': 63009,
    'bell': 63010,
    'bug': 63011,
    'bulb': 63012,
    'calculator': 63013,
    'check-circle-o': 63014,
    'check-circle': 63015,
    'clock': 63016,
    'delete-o': 63017,
    'doc': 63018,
    'drag': 63019,
    'envelope': 63020,
    'external link': 63021,
    'eye-hide': 63022,
    'eye-show': 63023,
    'flag': 63024,
    'frown': 63025,
    'history': 63026,
    'info-o': 63027,
    'key': 63028,
    'laptop': 63029,
    'lightning': 63030,
    'list-ul': 63031,
    'loading': 63032,
    'map': 63033,
    'meh': 63034,
    'minus': 63035,
    'needs-review': 63036,
    'note-o': 63037,
    'note': 63038,
    'ok': 63039,
    'photo': 63040,
    'plug': 63041,
    'question-circle-o': 63042,
    'question-circle': 63043,
    'search': 63044,
    'smile': 63045,
    'star-half': 63046,
    'star-o': 63047,
    'trash': 63048,
    'unarchive': 63049,
    'undo': 63050,
    'upload': 63051,
    'warning-o': 63052,
    'calendar': 63053,
    'filter': 63054,
    'review': 63055,
    'lightning-o': 63056,
  }
};
